<?php

namespace IQDEV\ElasticSearch\Order;

use IQDEV\ElasticSearch\Esable;

abstract class Order implements Esable
{
    public string $by;
    public OrderType $direction;
    public array $properties;

    public function __construct(string $by, OrderType $direction, array $properties = [])
    {
        $this->by = $by;
        $this->direction = $direction;
        $this->properties = $properties;
    }

    public function es(): array
    {
        return array_merge([$this->by => $this->direction::getType()], $this->properties);
    }
}
