<?php

namespace IQDEV\ElasticSearch\Indexer;

final class DeleteIndex implements Index
{
    private string $name;
    private ?string $id;

    public function __construct(
        string  $name,
        ?string $id = null
    )
    {
        $this->name = $name;
        $this->id = $id;
    }

    public function es(): array
    {
        $es = [
            'index' => $this->name
        ];

        if ($this->id) {
            $es['id'] = $this->id;
        }

        return $es;
    }
}
