<?php

namespace IQDEV\ElasticSearch\Indexer;

final class DeleteIndex implements Index
{
    public function __construct(
        private string  $name,
        private ?string $id = null
    ) {
    }

    public function es(): array
    {
        $es = [
            'index' => $this->name
        ];

        if ($this->id) {
            $es['id'] = $this->id;
        }

        return $es;
    }
}
