<?php

namespace IQDEV\ElasticSearch\Indexer;

use IQDEV\ElasticSearch\Esable;

final class BulkIndex implements Index
{
    public function __construct(
        private string  $name,
        private Esable  $body,
        private ?string $id = null
    ) {
    }

    public function es(): array
    {
        $es = [
            [
                'index' => [
                    '_index' => $this->name
                ]
            ]
        ];
        if ($this->id) {
            $es[0]['index']['_id'] = $this->id;
        }

        $es[] = $this->body->es();

        return $es;
    }
}
