<?php

namespace IQDEV\ElasticSearch\Indexer;

interface IndexProvider
{
    /**
     * Итерационное получение элемнтов для обновления
     *
     * @return \Generator|Index[]
     */
    public function get(): \Generator;

    /**
     * Установка размера пакета для передачив elasticsearch
     *
     * @param int $size
     *
     * @return void
     */
    public function setBatchSize(int $size): void;

    /**
     * Получение размера пакета для передачив elasticsearch
     *
     * @return int|null
     */
    public function getBatchSize(): ?int;

    /**
     * Установка лимита на количество обрабатываемых данных для индексации за один раз
     *
     * @param int $limit
     *
     * @return void
     */
    public function setLimit(int $limit): void;

    /**
     * Получение лимита на количество обрабатываемых данных для индексации за один раз
     *
     * @return int|null
     */
    public function getLimit(): ?int;
}
