<?php

namespace IQDEV\ElasticSearchTests\Seed;

use IQDEV\ElasticSearch\Config\BaseConfiguration;
use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Indexer\IndexRunner;
use IQDEV\ElasticSearchTests\Factory\ClientFactory;
use IQDEV\ElasticSearchTests\Helpers\TestIndexProvider;
use Psr\Log\NullLogger;

class DefaultSeed
{
    private IndexRunner $indexRunner;

    private Configuration $configuration;

    public function __construct()
    {
        $this->configuration = new BaseConfiguration();

        $this->indexRunner = new IndexRunner(
            ClientFactory::create(),
            $this->configuration,
            new NullLogger()
        );
    }

    public function start()
    {
        $provider = new TestIndexProvider($this->configuration, [
            [
                'id' => 's1',
                'name' => 'Кроссовки NMD_R1 Boba Fett Spectoo',
                'category' => 'shoes',
                'properties' => ['brand' => 'adidas', 'color' => 'green', 'size' => 46,'price' => 100],
                'year' => 2014,
                'new' => false,
                'rating' => 3,
            ],
            [
                'id' => 's2',
                'name' => 'КРОССОВКИ ULTRABOOST 5.0 DNA',
                'category' => 'shoes',
                'properties' => ['brand' => 'adidas', 'color' => 'red', 'size' => 47,'price' => 101],
                'year' => 2023,
                'new' => true,
                'rating' => 3,
            ],
            [
                'id' => 's3',
                'name' => 'Кроссовки Reebok Royal Techque',
                'category' => 'shoes',
                'properties' => ['brand' => 'rebook', 'color' => 'blue', 'size' => 47,'price' => 102],
                'year' => 1980,
                'new' => false,
                'rating' => 3,
            ],
            [
                'id' => 's4',
                'name' => 'Nike Air Zoom Pegasus 39',
                'category' => 'shoes',
                'properties' => ['brand' => 'nike', 'color' => 'green', 'size' => 43,'price' => 103],
                'year' => 2014,
                'new' => true,
                'rating' => 5,
            ],
            [
                'id' => 'h1',
                'name' => 'Nike Dri-FIT Strike',
                'category' => 't-short',
                'properties' => ['brand' => 'nike', 'color' => 'red', 'size' => 'xl','price' => 104],
                'year' => 2010,
                'new' => true,
                'rating' => 4,
            ],
            [
                'id' => 'h2',
                'name' => 'Nike Dri-FIT Rise 365',
                'category' => 't-short',
                'properties' => ['brand' => 'nike', 'color' => 'white', 'size' => 'xxl','price' => 105],
                'year' => 2000,
                'new' => true,
                'rating' => 3,
            ],
            [
                'id' => 'h3',
                'name' => 'Компрессионная Футболка ACTIVCHILL Graphic Move',
                'category' => 't-short',
                'properties' => ['brand' => 'rebook', 'color' => 'white', 'size' => 'xl','price' => 106],
                'year' => 1990,
                'new' => true,
                'rating' => 3,
            ],
            [
                'id' => 'p1',
                'name' => 'Товар с ценой',
                'category' => 'prices',
                'properties' => ['brand' => 'rebook', 'color' => 'white', 'size' => 'xl','price' => 107],
                'year' => 2015,
                'new' => false,
                'rating' => 3,
            ],
        ]);

        $this->indexRunner->run($provider);
    }
}
