<?php

namespace IQDEV\ElasticSearch\Search\Aggs;

use IQDEV\ElasticSearch\Esable;

final class AggsCollection implements Esable
{
    /**
     * @var Aggs[]
     */
    private array $aggs = [];

    public function add(Aggs $aggs): self
    {
        $this->aggs[] = $aggs;

        return $this;
    }

    public function es(): array
    {
        $aggs = [];
        foreach ($this->aggs as $agg) {
            $aggs[$agg->getKey()] = $agg->es();
        }

        return ['aggs' => $aggs];
    }
}
