<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter\Request\Aggregation;

use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Converter\Request\FilterQuery;
use IQDEV\ElasticSearch\Criteria\Filter\Collection\FilterCollection;
use IQDEV\ElasticSearch\Search\Aggs\Aggs;
use IQDEV\ElasticSearch\Search\Aggs\AggsCollection;
use IQDEV\ElasticSearch\Search\Aggs\AggsFacetStats;
use IQDEV\ElasticSearch\Search\Aggs\AggsFacetTerms;
use IQDEV\ElasticSearch\Search\Nested;

class FullAggregation
{
    public function __construct(
        private readonly Configuration $configuration,
        private readonly FilterCollection $filterCollection,
    ) {
    }

    public function updateRequestAggregation(AggsCollection $original): void
    {
        $keywordQuery = (new FilterQuery($this->configuration, $this->filterCollection->getKeywordFilters()))->getQuery();
        $numberQuery = (new FilterQuery($this->configuration, $this->filterCollection->getNumberFilters()))->getQuery();

        $aggsKeywordFiltered = new Aggs('keyword_facet_filtered');
        $aggsKeywordFiltered->addAggs(
            AggsFacetTerms::create(
                'all_keyword_facet_filtered',
                'keyword_facet'
            )
        );

        $aggsNumberFiltered = new Aggs('number_facet_filtered');
        $aggsNumberFiltered->addAggs(
            AggsFacetStats::create(
                'all_number_facet_filtered',
                'number_facet'
            )
        );

        if (false === $keywordQuery->getFilter()->isEmpty()) {
            foreach ($keywordQuery->getFilter() as $item) {
                $numberQuery->getFilter()->add($item);
            }
        }

        if (false === $numberQuery->getFilter()->isEmpty()) {
            foreach ($numberQuery->getFilter() as $item) {
                $keywordQuery->getFilter()->add($item);
            }
        }

        if (false === $keywordQuery->getFilter()->isEmpty()) {
            $aggsKeywordFiltered->setQuery($keywordQuery);
        } else {
            $aggsKeywordFiltered->setNested((new Nested())->setPath('search_data'));
        }

        if (false === $numberQuery->getFilter()->isEmpty()) {
            $aggsNumberFiltered->setQuery($numberQuery);
        } else {
            $aggsNumberFiltered->setNested((new Nested())->setPath('search_data'));
        }

        $original->add($aggsKeywordFiltered)->add($aggsNumberFiltered);
    }
}
