<?php

namespace IQDEV\ElasticSearchTests\Filter;

use IQDEV\ElasticSearch\Criteria\Aggs\Aggs;
use IQDEV\ElasticSearch\Criteria\Criteria;
use IQDEV\ElasticSearch\Criteria\Filter\Collection\FilterGroupCollection;
use IQDEV\ElasticSearch\Criteria\Filter\Field;
use IQDEV\ElasticSearch\Criteria\Filter\Filter;
use IQDEV\ElasticSearch\Criteria\Filter\FilterOperator;
use IQDEV\ElasticSearch\Criteria\Filter\Value\FilterNumber;
use IQDEV\ElasticSearch\Criteria\Query\SearchQuery;
use IQDEV\ElasticSearch\Document\Property\Property;
use IQDEV\ElasticSearchTests\AbstractTestCase;
use IQDEV\ElasticSearchTests\Helpers\FormatData;
use IQDEV\ElasticSearchTests\Service\SearchClient;

/**
 * Тестирование агрегирующих функций для прямых свойств документов
 */
class AggsPropsTest extends AbstractTestCase
{
    public function testCategoryAggs()
    {
        $criteria = new Criteria();
        $criteria->getAggs()->add(
            new Aggs(
                new Property('new')
            )
        );

        $q = new SearchQuery($criteria);

        $handler = SearchClient::getInstance();
        $result = $handler->handle($q)->result;

        $expected = [
            'hits' => [
                'h1',
                'h2',
                'h3',
                'p1',
                's1',
                's2',
                's3',
                's4',
            ],
            'facets' => [
                0 => [
                    'code' => 'new',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 0,
                                'count' => 3,
                                'active' => true
                            ],
                            1 => [
                                'label' => null,
                                'value' => 1,
                                'count' => 5,
                                'active' => true
                            ]
                        ],
                        'range' => []
                    ]
                ],
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatDataWFacets($result));
    }

    public function testCategoryAggsWFilters()
    {
        $criteria = new Criteria();
        $criteria->getAggs()->add(
            new Aggs(
                new Property('new')
            )
        );
        $criteria->getAggs()->add(
            new Aggs(
                new Property('rating')
            )
        );

        $filterCollectionPrice = new FilterGroupCollection([
            new Filter(
                new Field('price'),
                FilterOperator::GTE,
                new FilterNumber(105)
            )
        ]);
        $criteria->getFilters()->add($filterCollectionPrice);

        $q = new SearchQuery($criteria);

        $handler = SearchClient::getInstance();
        $result = $handler->handle($q)->result;

        $expected = [
            'hits' => [
                'h2',
                'h3',
                'p1'
            ],
            'facets' => [
                0 => [
                    'code' => 'brand',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'adidas',
                                'count' => 0,
                                'active' => false
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'nike',
                                'count' => 1,
                                'active' => true
                            ],
                            3 => [
                                'label' => null,
                                'value' => 'rebook',
                                'count' => 2,
                                'active' => true
                            ]
                        ],
                        'range' => []
                    ]
                ],
                1 => [
                    'code' => 'color',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'blue',
                                'count' => 0,
                                'active' => false
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'green',
                                'count' => 0,
                                'active' => false
                            ],
                            2 => [
                                'label' => null,
                                'value' => 'red',
                                'count' => 0,
                                'active' => false
                            ],
                            3 => [
                                'label' => null,
                                'value' => 'white',
                                'count' => 3,
                                'active' => true
                            ]
                        ],
                        'range' => []
                    ]
                ],
                2 => [
                    'code' => 'size',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                "label" => null,
                                "value" => "43",
                                "count" => 0,
                                "active" => false
                            ],
                            1 =>  [
                                "label" => null,
                                "value" => "46",
                                "count" => 0,
                                "active" => false
                            ],
                            2 =>  [
                                "label" => null,
                                "value" => "47",
                                "count" => 0,
                                "active" => false
                            ],
                            3 =>  [
                                "label" => null,
                                "value" => "xl",
                                "count" => 2,
                                "active" => true
                            ],
                            4 =>  [
                                "label" => null,
                                "value" => "xxl",
                                "count" => 1,
                                "active" => true
                            ],
                        ],
                        'range' => []
                    ]
                ],
                3 => [
                    'code' => 'price',
                    'label' => null,
                    'type' => 'range',
                    'items' => [
                        'list' => [],
                        'range' => [
                            0 => [
                                'label' => null,
                                'count' => 3,
                                'active' => true,
                                'fullRange' => [
                                    'min' => 100.0,
                                    'max' => 107.0
                                ],
                                'activeRange' => [
                                    'min' => 105.0,
                                    'max' => 107.0
                                ]
                            ]
                        ]
                    ],
                ],
                4 => [
                    'code' => 'new',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => "0",
                                'count' => 1,
                                'active' => true
                            ],
                            1 => [
                                'label' => null,
                                'value' => "1",
                                'count' => 2,
                                'active' => true
                            ]
                        ],
                        'range' => []
                    ]
                ],
                5 => [
                    'code' => 'rating',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => "3",
                                'count' => 3,
                                'active' => true
                            ],
                        ],
                        'range' => []
                    ]
                ],
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatDataWFacets($result));
    }

}
