<?php

namespace IQDEV\ElasticSearch\Search\BoolQuery;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Search\Nested;

final class Query implements Esable
{
    protected BoolQueryCollection $must;
    protected BoolQueryCollection $filter;
    protected BoolQueryCollection $should;
    protected BoolQueryCollection $mustNot;
    protected BoolQueryCollection $match;

    protected string $type;

    public const TYPE_QUERY = 'query';
    public const TYPE_FILTER = 'filter';

    public function __construct()
    {
        $this->must = new BoolQueryCollection();
        $this->filter = new BoolQueryCollection();
        $this->should = new BoolQueryCollection();
        $this->mustNot = new BoolQueryCollection();
        $this->match = new BoolQueryCollection();
        $this->type = self::TYPE_QUERY;
    }

    /**
     * @param Terms|Nested $item
     * @return $this
     */
    public function getMatch(): BoolQueryCollection
    {
        return $this->match;
    }

    public function getMust(): BoolQueryCollection
    {
        return $this->must;
    }

    public function getFilter(): BoolQueryCollection
    {
        return $this->filter;
    }

    public function setFilter(BoolQueryCollection $filter): BoolQueryCollection
    {
        return $this->filter;
    }

    public function getShould(): BoolQueryCollection
    {
        return $this->should;
    }

    public function getMustNot(): BoolQueryCollection
    {
        return $this->mustNot;
    }

    public function isEmpty(): bool
    {
        return $this->must->isEmpty()
            && $this->mustNot->isEmpty()
            && $this->filter->isEmpty()
            && $this->should->isEmpty();
    }

    public function setType(string $type): self
    {
        switch($type) {
            case self::TYPE_FILTER:
            case self::TYPE_QUERY:
                $this->type = $type;
                break;
            default:
                break;
        }
        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function es(): array
    {
        $bool = [];
        if (false === $this->filter->isEmpty()) {
            $bool['filter'] = $this->filter->es();
        }

        if (false === $this->must->isEmpty()) {
            $bool['must'] = $this->must->es();
        }

        if (false === $this->mustNot->isEmpty()) {
            $bool['must_not'] = $this->mustNot->es();
        }

        if (false === $this->should->isEmpty()) {
            $bool['should'] = $this->should->es();
            $bool['minimum_should_match'] = 1;
        }

        if (false === $this->match->isEmpty()) {
            $bool['match'] = $this->match->es();
        }

        return [
            $this->type => [
                'bool' => $bool,
            ],
        ];
    }

    public function modify(Query $another): self
    {
        foreach ($another->getMust() as $item) {
            $this->getMust()->add($item);
        }
        foreach ($another->getFilter() as $item) {
            $this->getFilter()->add($item);
        }
        foreach ($another->getShould() as $item) {
            $this->getShould()->add($item);
        }
        foreach ($another->getMustNot() as $item) {
            $this->getMustNot()->add($item);
        }
        foreach ($another->getMatch() as $item) {
            $this->getMatch()->add($item);
        }

        return $this;
    }

    public function __clone(): void
    {
        $this->must = clone $this->must;
        $this->should = clone $this->should;
        $this->filter = clone $this->filter;
        $this->mustNot = clone $this->mustNot;
        $this->match = clone $this->match;
    }
}
