<?php

namespace IQDEV\ElasticSearch\Search\BoolQuery;

use IQDEV\ElasticSearch\Esable;

final class Terms implements Esable
{
    /**
     * @param string $key
     * @param string|float|array<string|float> $value
     */
    public function __construct(
        private string $key,
        private string|float|array $value
    ) {
    }

    public function es(): array
    {
        $keyTerms = is_array($this->value) ? 'terms' : 'term';

        return [
            $keyTerms => [
                $this->key => $this->value,
            ],
        ];
    }
}
