<?php

namespace IQDEV\ElasticSearch\Facet;

use IQDEV\ElasticSearch\Document\Property\Property;
use IQDEV\ElasticSearch\Document\Property\PropertyType;
use IQDEV\ElasticSearch\Facet\Type\BaseFacet;
use IQDEV\ElasticSearch\Facet\Type\KeywordFacet;
use IQDEV\ElasticSearch\Facet\Type\NumberFacet;

class FacetFactory
{
    public static function createFromProperty(Property $property, mixed $value): Facet
    {
        match ($property->getType()) {
            PropertyType::KEYWORD => $facet = new KeywordFacet($property, $value),
            PropertyType::NUMBER => $facet = new NumberFacet($property, $value),
            default => $facet = new BaseFacet($property, $value),
        };

        return $facet;
    }
}
