<?php

namespace IQDEV\ElasticSearch\Criteria;

use IQDEV\ElasticSearch\Criteria\Filter\Collection\FilterCollection;
use IQDEV\ElasticSearch\Criteria\Order\OrderCollection;
use IQDEV\ElasticSearch\Criteria\Search\SearchCollection;

final class Criteria
{
    private SearchCollection $search;
    private FilterCollection $filters;
    private OrderCollection $sorting;
    private Pagination $pagination;

    public function __construct()
    {
        $this->search = new SearchCollection();
        $this->filters = new FilterCollection();
        $this->sorting = new OrderCollection();
        $this->pagination = new Pagination();
    }

    public function getSearch(): SearchCollection
    {
        return $this->search;
    }

    public function getFilters(): FilterCollection
    {
        return $this->filters;
    }

    public function getSorting(): OrderCollection
    {
        return $this->sorting;
    }

    public function getPagination(): Pagination
    {
        return $this->pagination;
    }

    public function __clone(): void
    {
        $this->search = clone $this->search;
        $this->filters = clone $this->filters;
        $this->sorting = clone $this->sorting;
        $this->pagination = clone $this->pagination;
    }
}
