<?php

namespace IQDEV\ElasticSearch\Config;

use IQDEV\ElasticSearch\Configuration;

class MappingValidator
{
    /**
     * Проверка существовая поля в описании индекса
     *
     * @param Configuration $configuration
     * @param string $property
     *
     * @return bool
     */
    public static function isPropertyExists(Configuration $configuration, string $property): bool
    {
        $properties = array_keys($configuration->getMapping()['properties'] ?? []);

        return in_array($property, $properties, true);
    }
}
