<?php

namespace IQDEV\ElasticSearchTests\Helpers;

class Arr
{
    /**
     * Flatten a multi-dimensional associative array with dots.
     * @param array $array
     * @param $prepend
     * @return array
     */
    public static function dot(array $array, $prepend = ''): array
    {
        $results = [];

        foreach ($array as $key => $value) {
            if (is_array($value) && ! empty($value)) {
                $results = array_merge($results, static::dot($value, $prepend.$key.'.'));
            } else {
                $results[$prepend.$key] = $value;
            }
        }

        return $results;
    }
}