<?php

namespace IQDEV\ElasticSearch\Search\BoolQuery;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Search\Nested;
use IQDEV\Search\Filter\FilterOperator;

final class FilterNumberFacet implements Esable
{
    public string $key;

    public array $conditions;

    public function __construct(string $key, array $conditions)
    {
        $this->key   = $key;
        $this->conditions = $conditions;
    }

    public function es(): array
    {
        $path = 'search_data.number_facet';

        $nested = new Nested();

        $query = new Query();
        $query
            ->filter(new Stats($path.'.facet_code', $this->key));

        $conditions = [];
        foreach ($this->conditions as $operator => $value) {
            switch ($operator) {
                case FilterOperator::GTE:
                    $key = 'gte';
                    break;
                case FilterOperator::LTE:
                    $key = 'lte';
                    break;
                case FilterOperator::GT:
                    $key = 'gt';
                    break;
                case FilterOperator::LT:
                    $key = 'lt';
                    break;
                default:
                    $key = null;
                    break;
            }
            if (isset($key)) {
                $conditions[$key] = $value;
            }
        }
        $query->filter(new Stats($path.'.facet_value', $conditions));

        $nested
            ->setPath($path)
            ->setQuery($query);

        return $nested->es();
    }
}
