<?php

namespace IQDEV\ElasticSearch\Search;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Order\OrderCollection;
use IQDEV\ElasticSearch\Search\Aggs\AggsCollection;
use IQDEV\ElasticSearch\Search\BoolQuery\Query;

final class Request implements Esable
{
    private ?Query $query = null;
    private ?Query $postFilter = null;
    private ?AggsCollection $aggs = null;
    private ?Pagination $pagination = null;
    private ?OrderCollection $sort = null;
    private array $match = [];
    private ?array $source = null;

    public function setPagination(?Pagination $pagination): self
    {
        $this->pagination = $pagination;

        return $this;
    }

    public function getQuery(): Query
    {
        if (null === $this->query) {
            $this->query = new Query();
        }

        return $this->query;
    }

    public function getPostFilter(): Query
    {
        if (null === $this->postFilter) {
            $this->postFilter = new Query();
        }

        return $this->postFilter;
    }

    public function getAggs(): AggsCollection
    {
        if (null === $this->aggs) {
            $this->aggs = new AggsCollection();
        }

        return $this->aggs;
    }

    public function getPagination(): ?Pagination
    {
        return $this->pagination;
    }

    public function addMatch(string $key, array $param): self
    {
        $this->match[$key] = $param;

        return $this;
    }

    public function setSource(array $s): self
    {
        $this->source = $s;

        return $this;
    }

    public function getSort(): OrderCollection
    {
        if (null === $this->sort) {
            $this->sort = new OrderCollection();
        }

        return $this->sort;
    }

    public function es(): array
    {
        $request = [];

        if ($this->source) {
            $request['_source'] = $this->source;
        }

        if ($this->postFilter && false === $this->postFilter->isEmpty()) {
            $request['post_filter'] = $this->postFilter->es()['query'];
        }

        if ($this->query && false === $this->query->isEmpty()) {
            $request['query'] = $this->query->es()['query'];
        }

        if (false === empty($this->match)) {
            foreach ($this->match as $key => $value) {
                $request['query']['match'][$key] = $value;
            }
        }

        if ($this->aggs) {
            $request['aggs'] = $this->aggs->es()['aggs'];
        }

        if ($this->pagination) {
            $request = array_merge($request, $this->pagination->es());
        }

        if ($this->sort) {
            $request['sort'] = $this->sort->es();
        }

        return $request;
    }
}
