<?php

namespace IQDEV\ElasticSearch\Indexer;

use IQDEV\ElasticSearch\Esable;

final class BulkIndex implements Index
{
    private string $name;
    private Esable $body;
    private ?string $id;

    public function __construct(
        string  $name,
        Esable  $body,
        ?string $id = null
    )
    {
        $this->name = $name;
        $this->body = $body;
        $this->id = $id;
    }

    public function es(): array
    {
        $es = [
            [
                'index' => [
                    '_index' => $this->name
                ]
            ]
        ];
        if ($this->id) {
            $es[0]['index']['_id'] = $this->id;
        }

        $es[] = $this->body->es();

        return $es;
    }
}
