<?php

namespace IQDEV\Search\Filter;

/**
 * @method static self query()
 * @method static self post()
 */
final class FilterType
{
    /**
     * Тип пост фильтрации
     */
    public const POST = 'post';
    /**
     * Тип полной фильтрации
     */
    public const QUERY = 'query';
    private string $operator;

    public function __construct(string $operator)
    {
        if (!in_array($operator, self::toArray(), true)) {
            throw new \InvalidArgumentException(sprintf('invalid operator %s', $operator));
        }

        $this->operator = $operator;
    }

    public function value(): string
    {
        return $this->operator;
    }

    /**
     * @return string[]
     */
    public static function toArray(): array
    {
        return [
            self::POST,
            self::QUERY
        ];
    }

    public static function __callStatic($method, $arguments)
    {
        if (in_array($method, self::toArray())) {
            return new self($method);
        }
    }
}
