<?php

namespace IQDEV\Search\SearchQuery;

use IQDEV\Search\Pagination;
use IQDEV\Search\Query;
use IQDEV\Search\SearchService;
use IQDEV\Search\Sorting\SortingCollection;
use IQDEV\Search\Sorting\SortingFieldPair;
use IQDEV\Search\Sorting\SortingPropertyKeywordPair;
use IQDEV\Search\Sorting\SortingPropertyNumberPair;

final class SearchQueryHandler
{
    private SearchService $searchService;

    public function __construct(SearchService $searchService)
    {
        $this->searchService = $searchService;
    }

    public function handle(SearchQuery $q): SearchResult
    {
        $query = new Query();

        if ($q->filters) {
            $query->filters = $q->filters;
        }

        if ($q->query) {
            $query->query = $q->query;
        }

        if ($q->limit || $q->page) {
            $query->pagination = new Pagination($q->limit, $q->page);
        }
        
        if ($q->sortBy) {
            $query->sorting = new SortingCollection();
            switch ($q->sortType) {
                case 'field':
                    $query->sorting->add(new SortingFieldPair($q->sortBy, $q->sortDirection));
                    break;
                case 'property_keywords':
                    $query->sorting->add(new SortingPropertyKeywordPair($q->sortBy, $q->sortDirection));
                    break;
                case 'property_number':
                    $query->sorting->add(new SortingPropertyNumberPair($q->sortBy, $q->sortDirection));
                    break;
                default:
                    break;
            }
        }

        $result = $this->searchService->search($query);

        $searchResult = new SearchResult();
        foreach ($result->facets as $facet) {
            $searchResult->facets->add($facet);
        }

        foreach ($result->hits as $hit) {
            $searchResult->hits->add($hit);
        }

        $searchResult->numPages   = $result->numPages;
        $searchResult->numProduct = $result->numProduct;

        return $searchResult;
    }
}