<?php

namespace IQDEV\Search\Filter;

class FilterNumber implements Filter
{
    public string $key;
    public float $min;
    public float $max;
    
    /**
     * @param string $key
     * @param float $min
     * @param float $max
     */
    public function __construct(
        string $key,
        float $min = 0,
        float $max = PHP_INT_MAX
    )
    {
        $this->key = $key;
        $this->min = $min;
        $this->max = $max;
    }

    public function key(): string
    {
        return $this->key;
    }

}
