<?php

namespace IQDEV\Search\Facet;

abstract class FacetItemType
{
    protected ?string $label = null;
    protected bool $selected = false;
    protected int $count = 0;

    /**
     * @return int
     */
    public function getCount(): int
    {
        return $this->count;
    }

    /**
     * @param string|null $sLabel
     * 
     * @return self
     */
    public function setLabel(?string $sLabel): self
    {
        $this->label = $sLabel;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLabel(): ?string
    {
        return $this->label;
    }

    /**
     * @return bool
     */
    public function isActive(): bool
    {
        return $this->count > 0;
    }

    /**
     * @return $this
     */
    protected function setSelected(bool $selected): self
    {
        $this->selected = $selected;
        return $this;
    }

    /**
     * @return bool
     */
    public function isSelected(): bool
    {
        return $this->selected;
    }
}