<?php

namespace IQDEV\Search\Facet;

class FacetItemRange extends FacetItemType
{
    /** range attributes */
    private ?float $min = null, $max = null;
    private ?float $selectedMin = null, $selectedMax = null;

    /**
     * @return array
     */
    public function getFullRange(): array
    {
        return [
            'min' => $this->min,
            'max' => $this->max
        ];
    }

    /**
     * @return array
     */
    public function getSelectedRange(): array
    {
        return [
            'min' => $this->selectedMin,
            'max' => $this->selectedMax
        ];
    }

    public static function createFromRange(
        ?float $min,
        ?float $max,
        int    $count,
        ?float $selectedMin = null,
        ?float $selectedMax = null
    ): self {
        $instance = new self();
        
        $instance->count = $count;

        $instance->min = $min;
        $instance->max = $max;
        $instance->selectedMin = $selectedMin;
        $instance->selectedMax = $selectedMax;

        return $instance;
    }
}