<?php

namespace IQDEV\Search\Facet;

class FacetItemList extends FacetItemType
{
    protected ?string $value = null;

    /**
     * @return string|null
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * @param string $value
     * @param int $count
     * 
     * @return static
     */
    public static function createFromValue(string $value, int $count): self
    {
        $instance = new self();
        $instance->count = $count;
        $instance->value = $value;

        return $instance;
    }
}