<?php

namespace IQDEV\Search\Facet;

final class Facet
{
    private FacetType $type;
    private string $code;
    private ?string $label = null;
    public FacetItemCollection $items;
    private int $position = 0;

    public function __construct(FacetType $type, string $code)
    {
        $this->type  = $type;
        $this->code  = $code;
        $this->items = new FacetItemCollection();
    }

    public function getLabel(): ?string
    {
        return $this->label;
    }

    public function getType(): FacetType
    {
        return $this->type;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function getPosition(): int
    {
        return $this->position;
    }
}