<?php

namespace IQDEV\Search\Filter;

/**
 * @method static self and()
 * @method static self or()
 */
final class LogicOperator
{
    public const AND = 'AND';
    public const OR = 'OR';
    private string $operator;

    public function __construct(string $operator)
    {
        if (!in_array($operator, self::toArray(), true)) {
            throw new \InvalidArgumentException(sprintf('invalid operator %s', $operator));
        }

        $this->operator = $operator;
    }

    public function value(): string
    {
        return $this->operator;
    }

    /**
     * @return string[]
     */
    public static function toArray(): array
    {
        return [
            self::AND,
            self::OR
        ];
    }

    public static function __callStatic($method, $arguments)
    {
        $method = strtoupper($method);
        if (in_array($method, self::toArray())) {
            return new self($method);
        }
    }
}
