<?php

namespace IQDEV\Search\Order;

use IQDEV\Search\Document\Property\Type;

class Order
{
    protected OrderType $type;
    protected Type $by;
    protected array $properties = [];

    public function __construct(Type $by, OrderType $type, array $properties = [])
    {
        $this->by = $by;
        $this->type = $type;
        $this->properties = $properties;
    }

    public function orderBy(): Type
    {
        return $this->by;
    }

    public function orderType(): OrderType
    {
        return $this->type;
    }

    public function orderProperties(): array
    {
        return $this->properties;
    }
}