<?php

namespace IQDEV\Search\Filter;

use Ramsey\Collection\AbstractCollection;

class FilterCollection extends AbstractCollection
{
    /** @var LogicOperator Тип логической операции для коллекции */
    protected LogicOperator $type;

    public function __construct(array $data = [])
    {
        parent::__construct($data);
        $this->type = new LogicOperator(LogicOperator::AND);
    }

    /**
     * @inheritDoc
     */
    public function getType(): string
    {
        return Filter::class;
    }

    /**
     * Установка типа логической операции
     *
     * @param LogicOperator $type
     *
     * @return $this
     */
    public function setLogicalType(LogicOperator $type): self
    {
        $this->type = $type;

        return $this;
    }
}
