<?php

namespace IQDEV\Search\Filter;

final class LogicOperator
{
    public const AND = 'AND';
    public const OR = 'OR';
    private string $operator;

    public function __construct(string $operator)
    {
        if (!in_array($operator, self::toArray(), true)) {
            throw new \InvalidArgumentException(sprintf('invalid operator %s', $operator));
        }

        $this->operator = $operator;
    }

    public function value(): string
    {
        return $this->operator;
    }

    /**
     * @return string[]
     */
    public static function toArray(): array
    {
        return [
            self::AND,
            self::OR
        ];
    }
}
