<?php

namespace IQDEV\Search\Filter;

final class Filter
{
    private Field $field;
    private FilterOperator $operator;
    private FilterValue $value;

    public function __construct(
        Field          $field,
        FilterOperator $operator,
        FilterValue    $value
    )
    {
        $this->field = $field;
        $this->operator = $operator;
        $this->value = $value;
    }

    public function field(): Field
    {
        return $this->field;
    }

    public function operator(): FilterOperator
    {
        return $this->operator;
    }

    public function value(): FilterValue
    {
        return $this->value;
    }
}
