<?php

namespace IQDEV\Search;

use IQDEV\Search\Filter\FilterGroupCollection;
use IQDEV\Search\Order\OrderCollection;

final class Criteria
{
    private FilterGroupCollection $filters;
    private OrderCollection $sorting;
    private Pagination $pagination;

    public function __construct()
    {
        $this->filters = new FilterGroupCollection();
        $this->sorting = new OrderCollection();
        $this->pagination = new Pagination();
    }

    public function filters(): FilterGroupCollection
    {
        return $this->filters;
    }

    public function sorting(): OrderCollection
    {
        return $this->sorting;
    }

    public function pagination(): Pagination
    {
        return $this->pagination;
    }
}
