<?php

namespace IQDEV\Search\Facet\Item;

abstract class FacetItem
{
    protected ?string $label = null;
    protected ?string $value = null;
    protected bool $selected = false;

    protected int $count = 0;

    abstract public static function create(): self;

    public function getLabel(): ?string
    {
        return $this->label;
    }

    public function getValue(): ?string
    {
        return $this->value;
    }

    public function getCount(): int
    {
        return $this->count;
    }

    public function isActive(): bool
    {
        return $this->count > 0;
    }

    public function isSelected(): bool
    {
        return $this->selected;
    }
}
