<?php

namespace Mail\Mjml\Mjml\TwigExtension;

use Twig\TwigFilter;
use Mail\Mjml\Mjml\Renderer\RendererInterface;
use Twig\Extension\AbstractExtension;

/**
 * Расширение для twig
 */
class MjmlExtension extends AbstractExtension
{
    /**
     * @var RendererInterface
     */
    protected $oRenderer;

    /**
     * MjmlExtension constructor.
     *
     * @param RendererInterface $renderer
     */
    public function __construct(RendererInterface $renderer)
    {
        $this->oRenderer = $renderer;
    }

    /**
     * @inheritDoc
     */
    public function getFilters(): array
    {
        return [
            new TwigFilter('mjml_to_html', [$this, 'render'], ['is_safe' => ['all']])
        ];
    }

    /**
     * Render MJML to HTML
     *
     * @param string $content
     *
     * @return string The generated HTML
     */
    public function render(string $content): string
    {
        return $this->oRenderer->render($content);
    }
}