<?php

namespace Mail\Mjml\Mjml\Renderer;

use Mail\Mjml\Mjml\Process\Process;

/**
 * 
 */
class BinaryRenderer implements RendererInterface
{
    /**
     * The MJML CLI path.
     *
     * @var string
     */
    private $bin;

    /**
     * @var string
     */
    private $command;

    /**
     * BinaryRenderer constructor.
     *
     * @param string $bin
     */
    public function __construct(string $bin)
    {
        $this->bin     = $bin;
        $this->command = "{$this->bin} -s -i --config.minify";
    }

    /**
     * @inheritDoc
     */
    public function render(string $content): string
    {
        $process = new Process($this->command, $content);
        $process->run();

        return (string)$process->getOutput();
    }
}