<?php

namespace Mail\Mjml\Mjml\RendererTemplate;

use Bitrix\Main\Application;
use CBitrixComponent;
use CBitrixComponentTemplate;
use Mail\Mjml\Mjml\Renderer\BinaryRenderer;
use Twig\Environment;
use Twig\Loader\FilesystemLoader;
use \Mail\Mjml\Mjml\TwigExtension\MjmlExtension;

/**
 * Подключение кастомного типа шаблона
 *
 * @param string $templateFile
 * @param array $arResult
 * @param array $arParams
 * @param array $arLangMessages
 * @param string $templateFolder
 * @param string $parentTemplateFolder
 * @param CBitrixComponentTemplate $template
 * 
 * @throws \Twig\Error\LoaderError
 * @throws \Twig\Error\RuntimeError
 * @throws \Twig\Error\SyntaxError
 */
function renderTemplateFile(
    $templateFile,
    $arResult,
    $arParams,
    $arLangMessages,
    $templateFolder,
    $parentTemplateFolder,
    $template
) {
    global $APPLICATION;

    if (($f = Application::getDocumentRoot() . $templateFile) && file_exists($f)) {
        if ($_REQUEST['clear_cache'] === 'Y') {
            touch($f);
        }
    }

    $loader = new FilesystemLoader(Application::getDocumentRoot());
    $twig   = new Environment($loader);


    $sPathToMjml = $_SERVER['DOCUMENT_ROOT'] . '/bitrix/modules/mail.mjml/node_modules/.bin/mjml';
    if (is_file($_SERVER['DOCUMENT_ROOT'] . '/local/modules/mail.mjml/install/index.php')) {
        $sPathToMjml = $_SERVER['DOCUMENT_ROOT'] . '/local/modules/mail.mjml/node_modules/.bin/mjml';
    }
    
    $renderer = new BinaryRenderer($sPathToMjml);

    $twig->addExtension(new MjmlExtension($renderer));
    
    echo $twig->render(
        $templateFile,
        $arResult['TEMPLATE_DATA']
    );

    $component_epilog = $templateFolder . '/component_epilog.php';
    if (file_exists($_SERVER['DOCUMENT_ROOT'] . $component_epilog)) {
        /** @var CBitrixComponent $component */
        $component = $template->getComponent();
        $component->SetTemplateEpilog(
            [
                'epilogFile'     => $component_epilog,
                'templateName'   => $template->__name,
                'templateFile'   => $template->__file,
                'templateFolder' => $template->__folder,
                'templateData'   => false,
            ]
        );
    }
}