<?php

use Bitrix\Main\Loader;
use Bitrix\Main\Localization\Loc;
use Mail\Mjml\Module;

if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) {
    die();
}

try {

    $module_id = Module::ID;

    if (!Loader::includeModule($module_id)) {
        throw new \RuntimeException('need to install module ' . $module_id);
    }

    if (CMain::GetGroupRight($module_id) <= "R") {
        throw new \RuntimeException(Loc::getMessage("ACCESS_DENIED"));
    }

    include __DIR__ . '/admin/includes/options.php';
    include __DIR__ . '/admin/assets/style.php';

} catch (Throwable $e) {
    $errors = [$e->getMessage()];

    include __DIR__ . '/admin/includes/errors.php';
    include __DIR__ . '/admin/assets/style.php';
}
