<?php

namespace Mail\Mjml;

use Bitrix\Main\Config\Option;

class Module
{
    public const ID = 'mail.mjml';

    public static function getDbOption($name, $default = ''): string
    {
        return Option::get(self::ID, $name, $default);
    }

    public static function setDbOption(string $name, string $value): void
    {
        if ($value !== Option::getRealValue(self::ID, $name)) {
            Option::set(self::ID, $name, $value);
        }
    }

    public static function removeDbOption(string $name): void
    {
        Option::delete(self::ID, ['name' => $name]);
    }

    public static function removeDbOptions(): void
    {
        Option::delete(self::ID);
    }
}