<?php

namespace Mail\Mjml\Mjml\TwigExtension;

use Twig\TwigFilter;
use Mail\Mjml\Mjml\Renderer\RendererInterface;
use Twig\Extension\AbstractExtension;

/**
 * Расширение для twig
 */
class MjmlExtension extends AbstractExtension
{
    /**
     * @var RendererInterface
     */
    protected $oRenderer;

    protected $aTwigFilter = [];

    /**
     * MjmlExtension constructor.
     *
     * @param RendererInterface $renderer
     */
    public function __construct(RendererInterface $renderer, array $aTwigFilter = [])
    {
        $this->oRenderer   = $renderer;
        $this->aTwigFilter = $aTwigFilter;
    }

    /**
     * @inheritDoc
     */
    public function getFilters(): array
    {
        return [
            new TwigFilter(
                'mjml_to_html',
                [$this, 'render'],
                array_merge(['is_safe' => ['all']], $this->aTwigFilter)
            )
        ];
    }

    /**
     * Render MJML to HTML
     *
     * @param string $content
     *
     * @return string The generated HTML
     */
    public function render(string $content): string
    {
        return $this->oRenderer->render($content);
    }
}