<?php

namespace Mail\Mjml\Mjml\RendererTemplate;

use Bitrix\Main\Application;
use CBitrixComponent;
use CBitrixComponentTemplate;
use Mail\Mjml\Mjml\Service\ExtensionService;
use Twig\Environment;
use Twig\Loader\FilesystemLoader;

/**
 * Подключение кастомного типа шаблона
 *
 * @param string $templateFile
 * @param array $arResult
 * @param array $arParams
 * @param array $arLangMessages
 * @param string $templateFolder
 * @param string $parentTemplateFolder
 * @param CBitrixComponentTemplate $template
 * 
 * @throws \Twig\Error\LoaderError
 * @throws \Twig\Error\RuntimeError
 * @throws \Twig\Error\SyntaxError
 */
function renderTemplateFile(
    $templateFile,
    $arResult,
    $arParams,
    $arLangMessages,
    $templateFolder,
    $parentTemplateFolder,
    $template
) {
    global $USER;

    if (($f = Application::getDocumentRoot() . $templateFile) && file_exists($f)) {
        if ($_REQUEST['clear_cache'] === 'Y' && $USER && $USER->IsAdmin()) {
            touch($f);
        }
    }

    $loader = new FilesystemLoader(Application::getDocumentRoot());
    $twig   = new Environment($loader);

    $twig->addExtension(ExtensionService::compileTwigExtension());
    
    echo $twig->render(
        $templateFile,
        $arResult['TEMPLATE_DATA']
    );

    $component_epilog = $templateFolder . '/component_epilog.php';
    if (file_exists($_SERVER['DOCUMENT_ROOT'] . $component_epilog)) {
        /** @var CBitrixComponent $component */
        $component = $template->getComponent();
        $component->SetTemplateEpilog(
            [
                'epilogFile'     => $component_epilog,
                'templateName'   => $template->__name,
                'templateFile'   => $template->__file,
                'templateFolder' => $template->__folder,
                'templateData'   => false,
            ]
        );
    }
}