<?php

use Bitrix\Main\Application;
use Bitrix\Main\EventManager;
use Bitrix\Main\IO\Directory;
use Bitrix\Main\Localization\Loc;
use Mail\Mjml\Events;
use Mail\Mjml\Module;

if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) {
    die();
}

class mail_mjml extends CModule
{
    public $MODULE_ID = 'mail.mjml';
    public $MODULE_NAME;
    public $MODULE_VERSION;
    public $MODULE_VERSION_DATE;
    public $MODULE_DESCRIPTION;
    public $PARTNER_NAME;
    public $PARTNER_URI;

    /**
     * Конструктор
     *
     * @return void
     */
    public function __construct()
    {
        $arModuleVersion = [];

        include(__DIR__ . '/version.php');

        $this->MODULE_VERSION      = $arModuleVersion['VERSION'];
        $this->MODULE_VERSION_DATE = $arModuleVersion['VERSION_DATE'];

        Loc::loadMessages(__FILE__);

        $this->MODULE_NAME        = Loc::getMessage('MODULE_NAME');
        $this->MODULE_DESCRIPTION = Loc::getMessage('MODULE_DESCRIPTION');
        $this->PARTNER_NAME       = Loc::getMessage('PARTNER_NAME');
        $this->PARTNER_URI        = Loc::getMessage('PARTNER_URI');
    }

    /**
     * Установка модуля
     *
     * @return void
     */
    function DoInstall()
    {
        RegisterModule($this->MODULE_ID);
        $this->installFiles();
        $this->registerEvents();
    }

    /**
     * Копирование файлов
     *
     * @return void
     */
    function InstallFiles()
    {
        CopyDirFiles(
            __DIR__ . '/components',
            Application::getDocumentRoot() . '/bitrix/components/',
            true,
            true
        );
        CopyDirFiles(__DIR__ . '/admin', Application::getDocumentRoot() . '/bitrix/admin');
        
        
    }

    /**
     * Регистрация событий
     * 
     * @return void
     */
    function registerEvents()
    {
        EventManager::getInstance()->registerEventHandler(
            'main',
            'OnProlog',
            $this->MODULE_ID,
            Events::class,
            'bindEvents'
        );
    }

    /**
     * Удаление файлов
     *
     * @return void
     */
    function UnInstallFiles()
    {
        $aDir = new DirectoryIterator(__DIR__ . '/components/iqdev/');
        foreach ($aDir as $oFileInfo) {
            if ($oFileInfo->isDir() && !$oFileInfo->isDot()) {
                Directory::deleteDirectory(
                    Application::getDocumentRoot() . '/bitrix/components/iqdev/' . $oFileInfo->getFilename() . '/'
                );
            }
        }
        DeleteDirFiles(__DIR__ . '/admin', Application::getDocumentRoot() . '/bitrix/admin');
    }

    /**
     * Удаление модуля
     *
     * @return void
     * @throws \Bitrix\Main\ArgumentNullException
     */
    function DoUninstall()
    {
        UnRegisterModule($this->MODULE_ID);
        $this->UnInstallFiles();
    }

    /**
     * Удаление событий
     *
     * @return void
     */
    function unRegisterEvents()
    {
        EventManager::getInstance()->unRegisterEventHandler(
            'main',
            'OnProlog',
            $this->MODULE_ID,
            Events::class,
            'bindEvents'
        );
    }
}