<?php

use Bitrix\Main\Localization\Loc;
use Mail\Mjml\Module;

if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) {
    die();
}

global $APPLICATION;

Loc::loadMessages(__FILE__);

$module_id = Module::ID;
$mid       = $_REQUEST["mid"];

$aCheckbox = [
    'use_event' => 'Y'
];

if ($_SERVER['REQUEST_METHOD'] === "POST" && check_bitrix_sessid()) {

    foreach ($aCheckbox as $sKey => $sDefault) {
        $sValue = $_REQUEST[$sKey] ?? 'N';
        Module::setDbOption($sKey, $sValue);
    }
}

$aTabs      = [
    [
        "DIV" => "edit1",
        "TAB" => Loc::getMessage("MAIN_TAB_SETTINGS"),
        "ICON" => "currency_settings",
        "TITLE" => Loc::getMessage("MAIN_TAB_TITLE_SETTINGS")
    ],
];
$tabControl = new CAdminTabControl("tabControl", $aTabs);

$tabControl->Begin();
?>
<form method="POST" action="<?= $APPLICATION->GetCurPage() ?>?mid=<?= htmlspecialcharsbx($mid) ?>&lang=<?= LANG ?>"
      name="mail.mjml">
    <?= bitrix_sessid_post(); ?>
    <?php
    $tabControl->BeginNextTab();
    ?>
    <?php foreach ($aCheckbox as $sKey => $sDefault) { ?>
        <?php $bChecked = Module::getDbOption($sKey, $sDefault) === 'Y' ?>
        <tr class="mjml-tr">
            <td>
                <label for="use_event"><?= Loc::getMessage("MAIN_TAB_" . mb_strtoupper($sKey)) ?></label>
            </td>
            <td>
                <input type="checkbox" name="use_event" id="use_event" value="Y" <?= $bChecked ? 'checked' : ''?>/>
            </td>
        </tr>
    <?php } ?>
    <?php
    $tabControl->Buttons();
    ?>

    <input type="submit" name="Update" value="<?= Loc::getMessage("MAIN_SAVE") ?>">
    <input type="hidden" name="Update" value="Y">

    <?php
    $tabControl->End(); ?>
</form>