# Модуль для генерации почтовых шаблонов из компонента

Mjml шаблонизатор https://documentation.mjml.io

## Использование со сторонними рендерами твига

Если на проекте подключен иной обработчик твиг-шаблонов, то необходимо выключить регистрацию обработчика модуля.
Необходимо перейти в настройки модуля и отключить свойство "Подключать обработчик шаблонов twig".

В нужном объекте twig зарегистрировать расширение, получив его через метод `\Mail\Mjml\Mjml\Service\ExtensionService::compileTwigExtension`

В перечень обрабатываемых файлов twig добавить расширение mjml.twig

```php
$arCustomTemplateEngines['twig'] = [
    'templateExt' => ['mjml.twig', 'twig'],
];
```

## Использование

В шаблоне письма выбрать режим "Визуальный редактор" и подключить компонент.
Например:

```php
$APPLICATION->IncludeComponent(
    'iqdev:mail.test', 
    '',
    [
        'username' => ['Иван', 'Петр']
    ]
);
```

### При использовании компонентов в шаблоне использовать файл template с расширением mjml.twig

Файл должен начинаться с тега ```{% apply mjml_to_html %} ```
и заканчиваться ```{% endapply %}```

Например

```twig
{% apply mjml_to_html %}
    <mjml>
        <mj-body>
            <mj-section>
                <mj-column>
                    <mj-text>Hello {{ username }}</mj-text>
                </mj-column>
            </mj-section>
        </mj-body>
    </mjml>
{% endapply %}
```

## Twig в шаблоне

В шаблоне помимо синтаксиса mjml можно использовать конструкции twig
Например, цикл:

```twig
<mj-column>
    {% for user in username %}
        <mj-text>Hello {{ user }}</mj-text>
    {% endfor %}
</mj-column>
```

## Параметры компонента для передачи в шаблон
В шаблон template.mjml.twig будут переданы данные из ```arResult['TEMPLATE_DATA']```
