<?php

namespace IQDEV\ElasticSearchTests;

use IQDEV\ElasticSearchTests\Helpers\Arr;
use PHPUnit\Framework\TestCase;

abstract class AbstractTestCase extends TestCase
{
    /**
     * Частичное сравнение массивов
     * @param array $expected
     * @param array $actual массив который должен иметь структуру и значения $expected
     * @param string $message
     * @return void
     */
    protected function assertArray(array $expected, array $actual, string $message = '')
    {
        $expectedKeys = Arr::dot($expected);
        $actualKeys = Arr::dot($actual);
        foreach ($expectedKeys as $key => $value) {
            $this->assertArrayHasKey($key, $actualKeys, $message);
            if (isset($actualKeys[$key])) {
                $this->assertEquals($actualKeys[$key], $value, $key);
            }
        }
    }
}