<?php

namespace IQDEV\ElasticSearch\Search;

use IQDEV\ElasticSearch\Esable;

class Pagination implements Esable
{
    public function __construct(
        private ?int $size = null,
        private ?int $from = null
    ) {
    }

    public function es(): array
    {
        $pagination = [];

        if ($this->from) {
            $pagination['from'] = $this->from;
        }

        if ($this->size) {
            $pagination['size'] = $this->size;
        }

        return $pagination;
    }
}
