<?php

namespace IQDEV\ElasticSearch\Search\BoolQuery;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Criteria\Filter\FilterOperator;
use IQDEV\ElasticSearch\Search\Nested;

final class FilterNumberFacet implements Esable
{

    public function __construct(
        public string $key,
        public array $conditions
    ) {
    }

    public function es(): array
    {
        $path = 'search_data.number_facet';

        $nested = new Nested();

        $query = new Query();
        $query
            ->getFilter()->add(new Stats($path.'.facet_code', $this->key));

        $conditions = [];
        foreach ($this->conditions as $operator => $value) {
            $key = in_array(FilterOperator::from($operator), [
                FilterOperator::GTE,
                FilterOperator::LTE,
                FilterOperator::GT,
                FilterOperator::LT,
            ]) ? $operator : null;

            if (isset($key)) {
                $conditions[$key] = $value;
            }
        }
        $query->getFilter()->add(new Stats($path.'.facet_value', $conditions));

        $nested
            ->setPath($path)
            ->setQuery($query);

        return $nested->es();
    }
}
