<?php

namespace IQDEV\ElasticSearch;

use IQDEV\ElasticSearch\Document\ProductCollection;
use IQDEV\ElasticSearch\Facet\Collection\FacetResultCollection;

class Result
{
    private ProductCollection $products;
    private FacetResultCollection $facets;
    private int $total = 0;

    public function __construct()
    {
        $this->products = new ProductCollection();
        $this->facets = new FacetResultCollection();
    }

    public function setTotal(int $total): void
    {
        $this->total = $total;
    }

    public function getTotal(): int
    {
        return $this->total;
    }

    public function getProducts(): ProductCollection
    {
        return $this->products;
    }

    public function getFacets(): FacetResultCollection
    {
        return $this->facets;
    }
}
