<?php

namespace IQDEV\ElasticSearch;

use Elastic\Elasticsearch\Client;
use Elastic\Elasticsearch\Exception\ClientResponseException;
use Elastic\Elasticsearch\Exception\ServerResponseException;
use IQDEV\ElasticSearch\Converter\CriteriaToEsRequest;
use IQDEV\ElasticSearch\Converter\EsResponseToResult;

class SearchService implements Searchable
{
    private Client $esClient;
    private Configuration $configuration;
    private CriteriaToEsRequest $criteriaToEsRequest;
    private EsResponseToResult $esResponseToResult;

    public function __construct(Client $esClient, Configuration $configuration)
    {
        $this->esClient = $esClient;
        $this->configuration = $configuration;

        $this->criteriaToEsRequest = new CriteriaToEsRequest();
        $this->esResponseToResult = new EsResponseToResult();
    }

    /**
     * @throws ServerResponseException
     * @throws ClientResponseException
     */
    public function search(Criteria $criteria): Result
    {
        $request = $this->criteriaToEsRequest->fromCriteria($criteria);

        $response = $this->esClient->search([
            'index' => $this->configuration->getIndexName(),
            'body' => $request->es(),
        ]);

        return $this->esResponseToResult->fromResponse($response);
    }
}
