<?php

namespace IQDEV\ElasticSearch\Query;

use IQDEV\ElasticSearch\SearchService;

final class SearchQueryHandler
{
    private SearchService $searchService;

    public function __construct(SearchService $searchService)
    {
        $this->searchService = $searchService;
    }

    public function handle(SearchQuery $q): SearchQueryResponse
    {
        $result = $this->searchService->search($q->criteria);

        return new SearchQueryResponse($result);
    }
}
