<?php

namespace IQDEV\ElasticSearch\Indexer;

use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Document\ProductDocument;
use IQDEV\ElasticSearch\Facet\FacetCategory;
use IQDEV\ElasticSearch\Facet\FacetKeyword;

class BaseIndexProvider implements IndexProvider
{
    private array $products;
    private ?int $size = null;
    private ?int $limit = null;
    private Configuration $configuration;

    public function __construct($products, $configuration)
    {
        $this->configuration = $configuration;
        $this->products = $products;
    }

    public function get(): \Generator
    {
        foreach ($this->products as $product) {
            $document = new ProductDocument(new FacetCategory($product['category']));
            $document->setAdditionData($product['data'] ?? []);
            foreach ($product['properties'] as $type => $values) {
                foreach ($values as $key => $prop) {
                    if ($type === 'number') {
                        $document->getNumberFacets()->add(new FacetKeyword($key, $prop));
                    } else {
                        $document->getKeywordFacets()->add(new FacetKeyword($key, $prop));
                    }
                }
            }
            $document->setSearchContent($product['name']);

            yield new AddIndex(
                $this->configuration->getIndexName(),
                $document,
                $product['id']
            );
        }
    }

    public function setBatchSize(int $size): void
    {
        $this->size = $size;
    }

    public function getBatchSize(): ?int
    {
        return $this->size;
    }

    public function setLimit(int $limit): void
    {
        $this->limit = $limit;
    }

    public function getLimit(): ?int
    {
        return $this->limit;
    }
}
