<?php

namespace IQDEV\ElasticSearch\Filter;

final class FilterOperator
{
    const EQ = '=';
    const NE = '!=';
    const GT = '>';
    const LT = '<';
    const GTE = '>=';
    const LTE = '<=';
    const CONTAINS = 'CONTAINS';
    const NOT_CONTAINS = 'NOT_CONTAINS';

    private string $operator;

    public function __construct(string $operator)
    {
        if (!in_array($operator, self::toArray(), true)) {
            throw new \InvalidArgumentException(sprintf('invalid operator %s', $operator));
        }

        $this->operator = $operator;
    }

    public function value(): string
    {
        return $this->operator;
    }

    /**
     * @return string[]
     */
    public static function toArray(): array
    {
        return [
            self::EQ,
            self::NE,
            self::GT,
            self::LT,
            self::GTE,
            self::LTE,
            self::CONTAINS,
            self::NOT_CONTAINS,
        ];
    }
}
